/*
 * Decompiled with CFR 0.152.
 */
package com.wardanger.dangerous;

import com.wardanger.dangerous.CreeperBehaviorManager;
import com.wardanger.dangerous.DangerousConfig;
import com.wardanger.dangerous.GearManager;
import com.wardanger.dangerous.MobDeathHandler;
import com.wardanger.dangerous.PillagerWeaponManager;
import com.wardanger.dangerous.SkeletonWeaponManager;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dangerous")
public class Dangerous {
    public static final String MODID = "dangerous";
    private static final Logger LOGGER = LoggerFactory.getLogger(Dangerous.class);
    private static final String HEALTH_MODIFIED_TAG = "dangerous_hp_modified";
    private float healthMultiplier = 1.0f;
    private double maxHealthMultiplier;
    private double healthMultiplierIncrement;
    private int daysPerIncrement;
    private static long lastCheckedDay = 0L;
    private boolean finalFormReached = false;

    public Dangerous() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DangerousConfig.COMMON_SPEC);
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new SkeletonWeaponManager());
        MinecraftForge.EVENT_BUS.register((Object)new PillagerWeaponManager());
        MinecraftForge.EVENT_BUS.register(CreeperBehaviorManager.class);
        MinecraftForge.EVENT_BUS.register((Object)new MobDeathHandler());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Dangerous Mod setup complete.");
    }

    @SubscribeEvent
    public void onConfigLoad(ModConfigEvent.Loading event) {
        this.loadConfigValues();
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading event) {
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        this.healthMultiplier = ((Double)DangerousConfig.CONFIG.baseHealthMultiplier.get()).floatValue();
        this.maxHealthMultiplier = (Double)DangerousConfig.CONFIG.maxHealthMultiplier.get();
        this.healthMultiplierIncrement = (Double)DangerousConfig.CONFIG.healthMultiplierIncrement.get();
        this.daysPerIncrement = (Integer)DangerousConfig.CONFIG.daysPerIncrement.get();
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            final ServerPlayer player = (ServerPlayer)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                final ServerLevel serverWorld = (ServerLevel)entity;
                boolean isFirstJoin = player.getPersistentData().m_128471_("dangerous_first_join");
                if (!isFirstJoin) {
                    player.getPersistentData().m_128379_("dangerous_first_join", true);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            Dangerous.this.sendWorldInfoToPlayer(player, serverWorld);
                        }
                    }, 2500L);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getPersistentData().m_128379_("dangerous_first_join", false);
        }
    }

    private void sendWorldInfoToPlayer(ServerPlayer player, ServerLevel world) {
        long currentDay = world.m_46468_() / 24000L;
        double healthMultiplier = ((Double)DangerousConfig.CONFIG.baseHealthMultiplier.get()).floatValue();
        int daysPerIncrement = (Integer)DangerousConfig.CONFIG.daysPerIncrement.get();
        long daysUntilNextIncrement = (long)daysPerIncrement - currentDay % (long)daysPerIncrement;
        MutableComponent dangerousMessage = Component.m_237113_((String)"            === Dangerous Mod Stats ===").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_178520_(0xFF5555));
        MutableComponent emptyLine = Component.m_237113_((String)" ");
        MutableComponent combinedMessage = Component.m_237113_((String)"Day: ").m_7220_((Component)Component.m_237113_((String)("" + currentDay)).m_130938_(style -> style.m_178520_(65280))).m_7220_((Component)Component.m_237113_((String)" | Mob HP Multiplier: ")).m_7220_((Component)Component.m_237113_((String)("" + healthMultiplier)).m_130938_(style -> style.m_178520_(0xFFFF55))).m_7220_((Component)Component.m_237113_((String)" | Days Until Next Increment: ")).m_7220_((Component)Component.m_237113_((String)("" + daysUntilNextIncrement)).m_130938_(style -> style.m_178520_(0x55FFFF)));
        if (((Boolean)DangerousConfig.CONFIG.enableChatAnnouncements.get()).booleanValue()) {
            player.m_213846_((Component)dangerousMessage);
            player.m_213846_((Component)emptyLine);
            player.m_213846_((Component)combinedMessage);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Dangerous Mod is ready and loaded!");
        this.loadConfigValues();
        ServerLevel overworld = event.getServer().m_129880_(ServerLevel.f_46428_);
        if (overworld != null) {
            long currentDay = overworld.m_46468_() / 24000L;
            this.initializeHealthMultiplier(currentDay);
        }
    }

    private void initializeHealthMultiplier(long currentDay) {
        long daysPassed = currentDay / (long)this.daysPerIncrement;
        int i = 0;
        while ((long)i < daysPassed) {
            if ((double)this.healthMultiplier < this.maxHealthMultiplier) {
                this.healthMultiplier += (float)this.healthMultiplierIncrement;
                if ((double)this.healthMultiplier > this.maxHealthMultiplier) {
                    this.healthMultiplier = (float)this.maxHealthMultiplier;
                    this.finalFormReached = true;
                    break;
                }
            }
            ++i;
        }
        lastCheckedDay = currentDay;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        ServerLevel serverWorld;
        Level level = event.level;
        if (level instanceof ServerLevel && !(serverWorld = (ServerLevel)level).m_5776_()) {
            long daysPassed;
            ServerLevelData worldData = (ServerLevelData)serverWorld.m_7654_().m_129910_();
            long currentDay = worldData.m_6792_() / 24000L;
            if (lastCheckedDay == 0L) {
                lastCheckedDay = currentDay;
            }
            if ((daysPassed = currentDay - lastCheckedDay) >= (long)this.daysPerIncrement) {
                long increments = daysPassed / (long)this.daysPerIncrement;
                for (long i = 0L; i < increments; ++i) {
                    this.increaseHealthMultiplier(serverWorld);
                }
                lastCheckedDay += increments * (long)this.daysPerIncrement;
            }
        }
    }

    private void increaseHealthMultiplier(ServerLevel world) {
        if ((double)this.healthMultiplier < this.maxHealthMultiplier) {
            this.healthMultiplier += (float)this.healthMultiplierIncrement;
            if ((double)this.healthMultiplier > this.maxHealthMultiplier) {
                this.healthMultiplier = (float)this.maxHealthMultiplier;
            }
            if (((Boolean)DangerousConfig.CONFIG.enableChatAnnouncements.get()).booleanValue()) {
                MutableComponent message = Component.m_237113_((String)"The enemies become more DANGEROUS!").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_178520_(0xFF5555));
                world.m_8795_(player -> true).forEach(arg_0 -> Dangerous.lambda$increaseHealthMultiplier$6((Component)message, arg_0));
                if ((double)this.healthMultiplier == this.maxHealthMultiplier && !this.finalFormReached) {
                    this.finalFormReached = true;
                    MutableComponent finalMessage = Component.m_237113_((String)"The enemies have reached their FINAL FORM!").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_178520_(0xFFAA00));
                    world.m_8795_(player -> true).forEach(arg_0 -> Dangerous.lambda$increaseHealthMultiplier$9((Component)finalMessage, arg_0));
                    LOGGER.info("The enemies have reached their FINAL FORM!");
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            Mob mob;
            ServerLevel serverWorld = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof Mob && (mob = (Mob)level) instanceof Monster) {
                Difficulty difficulty = serverWorld.m_46791_();
                this.adjustHealthBasedOnDifficulty((LivingEntity)mob, difficulty, this.healthMultiplier);
                GearManager.equipMobBasedOnDifficulty(mob, serverWorld);
            }
        }
    }

    private void adjustHealthBasedOnDifficulty(LivingEntity entity, Difficulty difficulty, float multiplier) {
        CompoundTag entityData = entity.getPersistentData();
        if (!entityData.m_128471_(HEALTH_MODIFIED_TAG)) {
            float originalHealth = entity.m_21233_();
            float newHealth = switch (difficulty) {
                case Difficulty.EASY, Difficulty.NORMAL, Difficulty.HARD -> originalHealth * multiplier;
                default -> originalHealth;
            };
            Objects.requireNonNull(entity.m_21051_(Attributes.f_22276_)).m_22100_((double)newHealth);
            entity.m_21153_(newHealth);
            entityData.m_128379_(HEALTH_MODIFIED_TAG, true);
        }
    }

    private static /* synthetic */ void lambda$increaseHealthMultiplier$9(Component finalMessage, ServerPlayer player) {
        player.m_213846_(finalMessage);
    }

    private static /* synthetic */ void lambda$increaseHealthMultiplier$6(Component message, ServerPlayer player) {
        player.m_213846_(message);
    }

    @Mod.EventBusSubscriber(modid="dangerous", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Dangerous Mod client setup complete.");
        }
    }
}

